Strict

Rem

	Vector helper class

End Rem
Type TVector2f

	Field x:Float
	Field y:Float

	Method New()
	
		x = 0
		y = 0
	
	End Method

	Method negate()
	
		x :* -1
		y :* -1
	
	End Method

	Method multiply(factor:Float)
		x :* factor
		y :* factor
	End Method

	Method constrain(maximum:Float, minimum:Float)
		x = Min(x, maximum)
		y = Min(y, maximum)
		x = Max(x, minimum)
		y = Max(y, minimum)
	End Method

	Method subtract(v:TVector2f)
		x :- v.x
		y :- v.y
	End Method

	Method add(v:TVector2f)
		x :+ v.x
		y :+ v.y
	End Method

	Method normalise()
		Local t:Float
		
		t = Sqr((x * x) + (y * y))
		x :/ t
		y :/ t
	End Method
	
	Method copyTo(v:TVector2f)
		v.x = x
		v.y = y
	End Method

	Function vectorDistance:Float(v1:TVector2f, v2:TVector2f)

		Local x:Float = v1.x - v2.x
		Local y:Float = v1.y - v2.y
	
		Return Sqr((x * x) + (y * y))
	End Function

EndType
