Rem

	Particle emitter

End Rem
Type TParticleEmitter Extends TParticle
	
	' How fast the bastard spins
	Field rotationalVelocity:Float
	
	' Whether the emitter is on or off
	Field emitting:Int
	' Number of particles to emit on each tick
	Field emitPerTick:Int
	' Number of ticks between emissions
	Field ticksPerEmit:Int
	' Number of ticks since the last emission
	Field ticksSinceEmit:Int
	
	' How wide the emission angle is
	Field spread:Float
	' Angle to emit the first particle
	Field startAngle:Float
	' Angle between particles on each emission
	Field angleStep:Float
	
	' Direction of the emitter
	Field direction:Float
	
	' Particle velocity
	Field particleVelocity:Float
	' Amount to vary the velocity of emitted particles
	Field particleVelocityVariance:Float
	' Particle energy
	Field particleEnergy:Int
	' Particle energy variance
	Field particleEnergyVariance:Int
	' Particles palette
	Field palette:Float[][]
	
	' Particle system
	Field ps:TParticleSystem
	
	Rem
		Emitter constructor
	End Rem
	Method New()
		Self.rotationalVelocity = 0
		Self.emitting = False
		Self.emitPerTick = 0
		Self.ticksPerEmit = 0
		Self.ticksSinceEmit = 0
		Self.spread = 0
		Self.startAngle = 0
		Self.angleStep = 0
		Self.direction = 0
		Self.particleVelocity = 0.0
		Self.particleVelocityVariance = 0.0
		Self.particleEnergy = 0
		Self.particleEnergyVariance = 0
	End Method
	
	Rem
		Initialise the emitter
	End Rem
	Method initEmitter(position:TVector2f, direction:Float, velocity:Float, rotationalVelocity:Float, energy:Int, emitterProps:TParticleEmitterProps, ps:TParticleSystem)
		' Initialise the position and such of the emitter
		Super.initParticle(position, direction, velocity, energy, Null)
		
		Self.emitPerTick = emitterProps.emitPerTick
		Self.ticksPerEmit = emitterProps.ticksPerEmit
		Self.direction = direction
		Self.setSpread(emitterProps.spread)

		' Initialise the properties of emitted particles
		Self.particleVelocity = emitterProps.particleVelocity
		Self.particleVelocityVariance = emitterProps.particleVelocityVariance
		Self.particleEnergy = emitterProps.particleEnergy
		Self.particleEnergyVariance = emitterProps.particleEnergyVariance
		Self.palette = emitterProps.palette
		
		Self.ps = ps
	End Method
	
	Rem
		Update the emission angle
	End Rem
	Method setSpread(spread:Float)
		Self.angleStep = spread / Self.emitPerTick
		Self.startAngle = -(spread / 2)
		Self.spread = spread
	End Method
	
	
	Method tick()
		Super.tick()
		
		Self.direction :+ Self.rotationalVelocity
		
		If Self.direction >= 359 Then
			Self.direction :- 360
		End If
		
		If Self.direction <= 0 Then
			Self.direction :+ 360
		End If
		
		Self.ticksSinceEmit :+ 1
		
		' Only emit if the emitter is on and a sufficient number of
		' ticks have elapsed since the last emission
		If Self.emitting And Self.ticksSinceEmit > Self.ticksPerEmit Then
			
			Local particlesToEmit:Int = Min(emitPerTick, ps.countAvailableParticles())
			Local i:Int = 0
			Local emitAngle:Float = Self.startAngle + Self.direction
			
			Local maxVelocity:Float = Self.particleVelocity + Self.particleVelocityVariance
			Local minVelocity:Float = Self.particleVelocity - Self.particleVelocityVariance
			Local maxEnergy:Int = Self.particleEnergy + Self.particleEnergyVariance
			Local minEnergy:Int = Self.particleEnergy - Self.particleEnergyVariance
			
			While i < particlesToEmit

				Local particleVelocity:Float = Float(Rnd(minVelocity, maxVelocity))
				Local particleEnergy:Int = Rand(minEnergy, maxEnergy)
				Local colour:Float[] = Self.palette[Rnd(0, Self.palette.length)]
				ps.emitParticle(Self.p, emitAngle, particleVelocity, particleEnergy, colour)

				emitAngle :+ Self.angleStep
				i :+ 1
			Wend
			
			Self.ticksSinceEmit = 0
			
		End If
		
	End Method
	
	Method startEmitting()
		Self.emitting = True
	End Method
	
	Method stopEmitting()
		Self.emitting = False
	End Method
	
End Type