Strict

Import "TVector2f.bmx"
Import "TParticle.bmx"

Rem

	Attractor particle

End Rem
Type TParticleAttractor Extends TParticle

	Field radius:Float
	Field K:Float
	Field maxAttraction:Float
	Field factor:Float
	
	Method attract(particle:TParticle)
		Local distance:Float, attraction:TVector2f, theta:Float, rho:Float
		'DebugLog("Attracting")
		attraction = New TVector2f
		attraction.x = p.x
		attraction.y = p.y
		
		attraction.subtract(particle.p)
		
		theta = Abs(ATan(attraction.y / attraction.x))

		If attraction.x < 0.0 And attraction.y > 0.0
			rho = 90.0 - theta
		ElseIf attraction.x < 0.0 And attraction.y < 0.0
			rho = 90.0 + theta
		ElseIf attraction.x > 0.0 And attraction.y < 0.0
			rho = 270.0 - theta
		Else
			rho = 270.0 + theta
		End If
		
		attraction.x = radius * Cos(rho)
		attraction.y = radius * Sin(rho)
		
		attraction.add(p)

		distance = TVector2f.vectorDistance(attraction, particle.p)

		attraction.subtract(particle.p)
		attraction.normalise()
		
		attraction.multiply((Self.K * m) / (distance * distance))
		If maxAttraction <> 0 Then
			attraction.constrain(maxAttraction, -maxAttraction)
		End If
		
		attraction.multiply(Self.factor)
		
		particle.applyForce(attraction)
		
	End Method

End Type