Strict

Import "TVector2f.bmx"
Rem

	Simple particle class

End Rem
Type TParticle

	' Current position
	Field p:TVector2f = New TVector2f
	' Previous position
	Field pOld:TVector2f = New TVector2f
	' Velocity
	Field v:TVector2f = New TVector2f
	' Mass
	Field m:Float = 1.0
	' Current energy. Particle dies when energy reaches zero
	Field energy:Int = 0
	' Start energy
	Field startEnergy:Int = 0
	' Colour
	Field colour:Float[] = [0.0, 0.0, 0.0]

	Rem
		Particle constructor.
	End Rem
	Method New()
		
	End Method

	Rem
		Initialise the particle with new properties
	End Rem
	Method initParticle(position:TVector2f, angle:Float, velocity:Float, energy:Int, colour:Float[])
		position.copyTo(Self.p)
		
		Self.v.x = velocity * Cos(angle)
		Self.v.y = velocity * Sin(angle)
		
		Self.energy = energy
		Self.startEnergy = energy
		
		Self.colour = colour
		
	End Method

	Rem
		Apply a force to the particle
	End Rem
	Method applyForce(f:TVector2f)
		'DebugLog("Old v: (" + Self.v.x + ", " + Self.v.y + ")")
		Self.v.add(f)
		'DebugLog("Applied force: (" + f.x + ", " + f.y + ")")
		'DebugLog("New v: (" + Self.v.x + ", " + Self.v.y + ")")
	End Method

	Rem
		Apply friction to the particle
	End Rem
	Method applyFriction(friction:Float)
		v.multiply(friction)
	End Method

	Rem
		Update the particle
	End Rem
	Method tick()

		Self.p.copyTo(Self.pOld)
		Self.p.add(Self.v)
		
		energy :- 1
		
	End Method


End Type
