Strict

Import "TParticle.bmx"
Import "TParticleSystem.bmx"

Global ScreenWidth:Int = 800
Global ScreenHeight:Int = 600
Global ScreenDepth:Int = 32
Global fov:Float = 45
Global zNear:Float = 2.0
Global zFar:Float = 100.0

Function createGLWindow(fullscreen:Int)

	If fullscreen Then
		GLGraphics(ScreenWidth, ScreenHeight, ScreenDepth, 0, GRAPHICS_BACKBUFFER | GRAPHICS_DEPTHBUFFER)
	Else
		GLGraphics(ScreenWidth, ScreenHeight, 0, 0, GRAPHICS_BACKBUFFER | GRAPHICS_DEPTHBUFFER)
	End If
End Function

Function sizeGLScene(width:Int, height:Int)

	glViewport(0, 0, width, height)						' Reset The Current Viewport

	glMatrixMode(GL_PROJECTION)							' Select The Projection Matrix
	glLoadIdentity()									' Reset The Projection Matrix
	'glTranslatef(0, 0, 100.0)
	' Calculate The Aspect Ratio Of The Window
	gluPerspective(fov, width / height, zNear, zFar)

	glMatrixMode(GL_MODELVIEW)							' Select The Modelview Matrix
	glLoadIdentity()									' Reset The Modelview Matrix

End Function

Function initGL()
	glShadeModel(GL_SMOOTH)								' Enable Smooth Shading
	glClearColor(0.0, 0.0, 0.0, 0.0)					' Black Background
	glClearDepth(1.0)									' Depth Buffer Setup
	glDisable(GL_DEPTH_TEST)							' Enables Depth Testing
	glEnable(GL_VERTEX_ARRAY)
	glEnable(GL_TEXTURE_COORD_ARRAY)
	glEnable(GL_COLOR_ARRAY)
	glEnable(GL_TEXTURE_2D)
	'glDepthFunc(GL_LEQUAL)								' The Type Of Depth Testing To Do
	glEnable(GL_BLEND)
	glBlendFunc(GL_SRC_ALPHA, GL_ONE)
	'glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)	' Really Nice Perspective Calculations
	glEnable(GL_VERTEX_ARRAY)
	glEnable(GL_TEXTURE_COORD_ARRAY)
	glEnable(GL_COLOR_ARRAY)
End Function

Function main()
	
	Local ps:TParticleSystem = New TParticleSystem
	Local emitter1:TParticleEmitter = New TParticleEmitter
	Local emitter2:TParticleEmitter = New TParticleEmitter
	Local attractor1:TParticleAttractor = New TParticleAttractor
	Local attractor2:TParticleAttractor = New TParticleAttractor
	
	Local minBounds:TVector2f = New TVector2f
	Local maxBounds:TVector2f = New TVector2f
	
	Local palette:Float[][][] = ..
	[ ..
		[[0.8, 0.2, 0.2], [0.2, 0.8, 0.2], [0.2, 0.8, 1.0]], ..
		[[1.0, 0.0, 0.0], [0.8, 0.2, 0.2], [0.8, 0.5, 0.2], [0.8, 0.2, 0.5]], ..
		[[0.0, 1.0, 0.0], [0.2, 0.8, 0.2], [0.5, 0.8, 0.2], [0.2, 0.8, 0.5]], ..
		[[1.0, 0.0, 1.0], [0.2, 0.2, 0.8], [0.5, 0.2, 0.8], [0.2, 0.5, 0.8]], ..
		[[1.0, 0.0, 0.0], [1.0, 0.2, 0.0], [1.0, 0.4, 0.2]], ..
		[[0.6, 0.6, 0.6]] ..
	]
	
	ps.initSystem(10000, minBounds, maxBounds)
	ps.setTexture("particle2.png")
	ps.particleSize = 1
	ps.zDistance = -80
	ps.friction = 0.93
	
	Local emitterPosition:TVector2f = New TVector2f
	emitterPosition.x = 0
	emitterPosition.y = 0
	Local emitter1RV = 0.0
	Local emitter1Direction:Float = 90.0
	Local emitter1Props:TParticleEmitterProps = New TParticleEmitterProps
	emitter1Props.emitPerTick = 10
	emitter1Props.ticksPerEmit = 10
	emitter1Props.spread = 45
	emitter1Props.particleVelocity = 0.01
	emitter1Props.particleVelocityVariance = 0.2
	emitter1Props.particleEnergy = 500
	emitter1Props.particleEnergyVariance = 20
	emitter1Props.palette = palette[0]

	emitter1.initEmitter(emitterPosition, emitter1Direction, 0, emitter1RV, 0, emitter1Props, ps)
	emitter1.emitting = True
	
	ps.addEmitter(emitter1)
	Rem
	emitterPosition.x = 25
	emitter2.initEmitter(emitterPosition, 359, 0, 0, emitterProps, ps)
	emitter2.emitting = True
	
	ps.addEmitter(emitter2)
	End Rem
	Local attractorPosition:TVector2f = New TVector2f
	attractorPosition.x = -10
	attractorPosition.y = 0
	
	attractor1.initParticle(attractorPosition, 0, 0, 0, Null)
	attractor1.m = 4
	attractor1.radius = 10
	attractor1.K = 1.1
	attractor1.factor = 1.0
	ps.addAttractor(attractor1)
	
	attractorPosition.x = 10
	attractorPosition.y = 0
	attractor2.initParticle(attractorPosition, 0, 0, 0, Null)
	attractor2.m = 4
	attractor2.radius = 10
	attractor2.K = 1.1
	attractor2.factor = 1.0
	ps.addAttractor(attractor2)
	
	Local Framecounter_counter:Int, Framecounter_time:Int, Framecounter_framerate:Int
	Local showHelp:Int = False
	
	DebugLog("About to start running")
	
	HideMouse()
	
	While Not KeyHit(KEY_ESCAPE)
	
		If KeyHit(KEY_H) Then
			showHelp = Not showHelp
		End If
	
		' Change to red particles
		If KeyHit(KEY_1) Then
			emitter1Props.palette = palette[0]
			emitter1.palette = palette[0]
		End If
		
		' Change to green particles
		If KeyHit(KEY_2) Then
			emitter1Props.palette = palette[1]
			emitter1.palette = palette[1]
		End If
		
		' Change to blue particles
		If KeyHit(KEY_3) Then
			emitter1Props.palette = palette[2]
			emitter1.palette = palette[2]
		End If
		
		If KeyHit(KEY_4) Then
			emitter1Props.palette = palette[3]
			emitter1.palette = palette[3]
		End If
		
		If KeyHit(KEY_5) Then
			emitter1Props.palette = palette[4]
			emitter1.palette = palette[4]
		End If
		
		If KeyHit(KEY_6) Then
			emitter1Props.palette = palette[5]
			emitter1.palette = palette[5]
		End If
	
		' Control emitter depth
		If KeyDown(KEY_UP) Then
			ps.zDistance :- 0.2
		End If
		
		If KeyDown(KEY_DOWN) Then
			ps.zDistance :+ 0.2
		End If
	
		' Change emitter direction
		If KeyDown(KEY_A) Then
			emitter1.rotationalVelocity :- 0.1
		End If
		
		If KeyDown(KEY_D) Then
			emitter1.rotationalVelocity :+ 0.1
		End If
		
		' Control emitter velocity
		If KeyDown(KEY_LEFT) Then
			emitter1Props.particleVelocity :+ 0.01
			emitter1.initEmitter(emitterPosition, emitter1.direction, 0, emitter1.RotationalVelocity, 0, emitter1Props, ps)
		End If
		
		If KeyDown(KEY_RIGHT) Then
			emitter1Props.particleVelocity :- 0.01
			emitter1.initEmitter(emitterPosition, emitter1.direction, 0, emitter1.RotationalVelocity, 0, emitter1Props, ps)
		End If
	
		If KeyHit(KEY_P) Then
			emitter1Props.emitPerTick :+ 1
			emitter1.initEmitter(emitterPosition, emitter1.direction, 0, emitter1.RotationalVelocity, 0, emitter1Props, ps)
		End If
		
		If KeyHit(KEY_L) Then
			If emitter1Props.emitPerTick > 1
				emitter1Props.emitPerTick :- 1
				emitter1.initEmitter(emitterPosition, emitter1.direction, 0, emitter1.RotationalVelocity, 0, emitter1Props, ps)
			End If
		End If
	
		' Change emitter spread
		If KeyDown(KEY_W) Then
			If emitter1Props.spread < 360 Then
				emitter1Props.spread :+ 1
				emitter1.initEmitter(emitterPosition, emitter1.direction, 0, emitter1.RotationalVelocity, 0, emitter1Props, ps)
			End If
		End If
		
		If KeyDown(KEY_S) Then
			If emitter1Props.spread > 0 Then
				emitter1Props.spread :- 1
				emitter1.initEmitter(emitterPosition, emitter1.direction, 0, emitter1.RotationalVelocity, 0, emitter1Props, ps)
			End If
		End If
		
		If KeyDown(KEY_Z) Then
			If ps.particleSize > 0.1 Then
				ps.particleSize :- 0.1
			End If
		End If
		
		If KeyDown(KEY_X) Then
			If ps.particleSize < 10.0 Then
				ps.particleSize :+ 0.1
			End If
		End If
		
		If KeyDown(KEY_O) Then
			attractor1.m :+ 0.1
			attractor2.m :+ 0.1
		End If
		
		If KeyDown(KEY_K) Then
			If attractor1.m > 0 And attractor2.m > 0 Then
				attractor1.m :- 0.1
				attractor2.m :- 0.1
			End If
		End If
		
		If KeyDown(KEY_I) Then
			attractor1.radius :+ 0.1
			attractor2.radius :+ 0.1
		End If
		
		If KeyDown(KEY_J) Then
			If attractor1.radius > 0 And attractor2.radius > 0 Then
				attractor1.radius :- 0.1
				attractor2.radius :- 0.1
			End If
		End If
		
		If KeyDown(KEY_M) Then
			ps.particleDisplayDelay :+ 1
		End If
		
		If KeyDown(KEY_N) Then
			If ps.particleDisplayDelay > 0 Then
				ps.particleDisplayDelay :- 1
			End If
		End If
		
		If KeyHit(KEY_SPACE) Then
			emitter1.emitting = Not emitter1.emitting
		End If
		
		If KeyHit(KEY_0) Then
			ps.isAttracting = Not ps.isAttracting
		End If
		
		If KeyHit(KEY_EQUALS) Then
			attractor1.factor :* -1
			attractor2.factor :* -1
		End If
	
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)  ' Clear The Screen And The Depth Buffer
		glLoadIdentity()														           ' Reset The Current Modelview Matrix
		
		'DebugLog("********************** Tick *****************************")
		ps.tick()
		ps.render()
		glColor3f(1.0,1.0,1.0)
		'Framecounter--------------------------------------------
		Framecounter_counter=Framecounter_counter+1
		If Framecounter_time=0 Then Framecounter_time=MilliSecs()
		If Framecounter_time+1001 <MilliSecs() Then
			Framecounter_framerate=Framecounter_counter
			Framecounter_counter=0
			Framecounter_time=MilliSecs()
		EndIf
		GLDrawText("FPS : "+Framecounter_framerate,ScreenWidth-(8*12),ScreenHeight-16-8)
		'--------------------------------------------------------
		
		GLDrawText(ps.particleCount + " particles on screen", 8, 8)
		
		If showHelp Then
			Local helpY:Int = 60
			GLDrawText("Up/Down: Move emitter away from/towards the camera (" + ps.zDistance + ")", 8, helpY + 15)
			GLDrawText("Right/Left arrows: Increase/Decrease particle velocity (" + emitter1Props.particleVelocity + ")", 8, helpY + 30)
			GLDrawText("W/S: Widen/Tighten emission angle (" + emitter1Props.spread + ")", 8, helpY + 45)
			GLDrawText("A/D: Decrease/Increase emitter rotational velocity (" + emitter1.rotationalVelocity + ")", 8, helpY + 60)
			GLDrawText("Z/X: Decrease/Increase particle size (" + ps.particleSize + ")", 8, helpY + 75)
			GLDrawText("P/L: Increase/Decrease number of particles emitted at a time (" + emitter1Props.emitPerTick + ")", 8, helpY + 90)
			GLDrawText("O/K: Increase/Decrease attractor mass (" + attractor1.m + ")", 8, helpY + 105)
			GLDrawText("I/J: Increase/Decrease attractor radius (" + attractor1.radius + ")", 8, helpY + 120)
			GLDrawText("SPACE: Toggle emission on and off", 8, helpY + 135)
			GLDrawText("0: Toggle attraction on and off", 8, helpY + 150)
			GLDrawText("=: Toggle repulsion/attraction", 8, helpY + 165)
			GLDrawText("1/2/3/4/5: Change palette", 8, helpY + 180)
		End If
		
		Flip

	Wend
	
	ShowMouse()
	
End Function

Local result:Int = Proceed("Would You Like To Run In Fullscreen Mode?")
Select result
	Case -1
		End
	Case 0
		createGLWindow(False)
	Case 1
		createGLWindow(True)
End Select
sizeGLScene(screenWidth, screenHeight)
initGL()
main()
