/*
 * Created on Sep 18, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author james
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class World
{

	public static final int WORLD_HEIGHT = 200;
	public static final float G = -0.1f;

	private static final int MAX_BARS = 8;
	public static final int BAR_DISTANCE = 150;

	private static final float WORLD_CENTER_X = 100;
    private static final float WORLD_CENTER_Y = World.WORLD_HEIGHT >> 1;
    private static final float WORLD_CENTER_Z = 0;
    private static final float TUNNEL_START_X = -100;
    private static final float TUNNEL_END_X = 2000;
    
    public static final int STATE_STARTING = 1;
    public static final int STATE_PLAYING = 2;
    public static final int STATE_DYING = 4;
    public static final int STATE_GAME_OVER = 8;

    public int state;

    private Game game;
    private BGraphics g;
    
	Bar bars[] = new Bar[MAX_BARS];
    Ship ship;
    boolean shipThrusting = false;
    int ticks;
    public int gameTicks;
    public int score;
    public int level;
    int closestBar;
    
	public int barsPassed = 0;
	public int closeOneCount = 0;
	public int sneakyBuggerCount = 0;
	public int bestSparksFlying = 0;
	public int totalSparksFlying = 0;
    
    // Bonus stuff
    float closeOneHeight;		// distance between the bar and the ceiling or floor
    int skirtingDuration;		// number of ticks the ship has been skirting the ceiling or floor
    int bonusTextAlpha = 0;		// Bonus text alpha channel value
    String bonusText = "";		// Current bonus text
    
    private static final int BONUS_FADE_SPEED = 3;			// Speed that the bonus text alpha channel decreases by.
    public static final int MAX_SKIRTING_HEIGHT = 25;		// The threshold for the distance between the ship and
    														// the floor or ceiling at which the ship is considered
    														// to be "skirting".
    private static final int MIN_SKIRTING_DURATION = 60;	// The minimum number of ticks that the ship must skirt
    														// for to receive a bonus.
    
    private static final int BONUS_TYPE_VERY_CLOSE_ONE = 1;
    private static final int BONUS_TYPE_CLOSE_ONE = 2;
    private static final int BONUS_TYPE_SKIRTING = 3;
    
    World(Game game)
    {
    	this.game = game;
    	this.g = game.g;
    	this.ship = new Ship(World.WORLD_CENTER_X, World.WORLD_CENTER_Z);
    	this.init();
    }

    public void init()
    {
    	this.closeOneHeight = World.WORLD_HEIGHT;
    	this.skirtingDuration = 0;
    	this.bonusText = "";
    	this.bonusTextAlpha = 0;
    	this.gameTicks = 0;
    	this.score = 0;
		this.level = 1;
		this.barsPassed = 0;
		this.closeOneCount = 0;
		this.sneakyBuggerCount = 0;
		this.bestSparksFlying = 0;
		this.totalSparksFlying = 0;
		this.shipThrusting = false;
		
		this.setState(World.STATE_STARTING);
    	for (int i = 0; i < MAX_BARS; i++)
    	{
    		this.bars[i] = new Bar(game.noise(i * 2) * World.WORLD_HEIGHT, WORLD_CENTER_X + BAR_DISTANCE * (i + 1), WORLD_CENTER_Z);
    		this.bars[i].hVelocity = 1 + ((float)this.level / 4.0f);
    		this.bars[i].hVelocity *= Math.random() > 0.5 ? 1 : -1;
    	}
    	closestBar = 0;
    	ship.init(World.WORLD_CENTER_Y);
		
    }
    
    public void setState(int state)
    {
    	if (state == World.STATE_DYING)
    	{
    		this.gameTicks = this.ticks;
    	}
    	this.ticks = 0;
    	this.state = state;
    }
    
    public void doTick()
    {
    	
    	switch (this.state)
		{
    		case World.STATE_STARTING:
    			this.doStartingTick();
    			break;
			
			case World.STATE_PLAYING:
    			this.doGameTick();
    			break;
    		
    		case World.STATE_DYING:
    			this.doDyingTick();
    			break;
		}
    	ticks++;
    }

    private void doStartingTick()
    {
    	if (this.ticks >= 135)
    	{
    		this.setState(World.STATE_PLAYING);
    	}
    }
    
    private void doGameTick()
    {
    	this.score++;
    	this.shipThrusting = game.mousePressed;
    	if (game.keyPressed)
    	{
    		if (game.key == ' ' || game.key == Game.UP)
    		{
    			this.shipThrusting = true;
    		}
    	}
    	
    	ship.doTick(this.shipThrusting);
    	this.shipThrusting = false;
    	
    	if (ship.h <= Ship.HALF_SHIP_WIDTH || ship.h >= World.WORLD_HEIGHT - Ship.HALF_SHIP_WIDTH)
    	{
    		this.setState(World.STATE_DYING);
    		return;
    	}
        int i = bars.length;
        while (i-- > 0)
        {
        	if (bars[i].x <= -50)
        	{
        		int prevBar = i == 0 ? MAX_BARS - 1 : i - 1;
        		bars[i].reset(game.noise(i * 2, bars[i].h) * World.WORLD_HEIGHT, bars[prevBar].x + BAR_DISTANCE, 1 + ((float)this.level / 4.0f));
        		this.bars[i].hVelocity *= Math.random() > 0.5 ? 1 : -1;
        	}
        	bars[i].doTick();
        	
        }
        
        // Test for collision
    	float bx1 = bars[closestBar].x;
    	float bx2 = bars[closestBar].x + Bar.BAR_WIDTH;
    	float by1 = bars[closestBar].h;
    	float by2 = bars[closestBar].h + Bar.BAR_WIDTH;
    	float sx1 = WORLD_CENTER_X;
    	float sx2 = WORLD_CENTER_X + Ship.SHIP_LENGTH;
    	float sy1 = ship.h;
    	float sy2 = ship.h + Ship.SHIP_WIDTH;
    	
    	boolean xPlaneColliding = (bx1 < sx2 && bx2 > sx1);
    	boolean yPlaneColliding = (by1 < sy2 && by2 > sy1);
    	
    	if (xPlaneColliding && yPlaneColliding)
    	{
    		this.setState(World.STATE_DYING);
    		return;
    	}
    	
    	int prevLevel = this.level;
    	this.level = Math.abs(this.ticks / 1000) + 1;
    	
    	if (prevLevel != this.level)
    	{
    		float hVelocity = 1 + ((float)this.level / 4.0f);
    		i = bars.length;
            while (i-- > 0)
            {
            	bars[i].hVelocity = bars[i].hVelocity > 0 ? hVelocity : -hVelocity; 
            }
    	}

    	this.testBonuses();
    	
        // Set the closest bar
        if (bars[closestBar].x + Bar.HALF_BAR_WIDTH < World.WORLD_CENTER_X - Ship.HALF_SHIP_LENGTH)
        {
        	closestBar++;
    		if (closestBar >= MAX_BARS)
    		{
    			closestBar = 0;
    		}
    		this.barsPassed++;
        }
    }
    
    private void testBonuses()
    {
    	// Test for bonuses
    	
    	// Close one bonus
    	if (ship.x1 < bars[closestBar].x && ship.x2 > bars[closestBar].x)
    	{
    		// The ship is in the bonus area. Check how narrow the gap is. 
    		float currentCloseOneHeight = bars[closestBar].h < ship.h ? WORLD_HEIGHT - bars[closestBar].h : bars[closestBar].h;
    		if (currentCloseOneHeight < this.closeOneHeight)
    		{
    			this.closeOneHeight = currentCloseOneHeight;
    		}
    	}
    	else if (bars[closestBar].x + Bar.HALF_BAR_WIDTH < World.WORLD_CENTER_X - Ship.HALF_SHIP_LENGTH)
    	{
    		// The ship has just passed the bar. Time to award bonuses if necessary.
    		if (this.closeOneHeight < WORLD_HEIGHT >> 2)
    		{
    			this.awardBonus(World.BONUS_TYPE_VERY_CLOSE_ONE, 500);
    		}
    		else if (this.closeOneHeight < WORLD_HEIGHT >> 1)
    		{
    			this.awardBonus(World.BONUS_TYPE_CLOSE_ONE, 50);
    		}
    		this.closeOneHeight = World.WORLD_HEIGHT;
    	}
    	
    	if (ship.h < World.MAX_SKIRTING_HEIGHT || (World.WORLD_HEIGHT - ship.h) < World.MAX_SKIRTING_HEIGHT)
    	{
    		this.skirtingDuration++;
    	}
    	else
    	{
    		if (this.skirtingDuration > World.MIN_SKIRTING_DURATION)
    		{
        		this.awardBonus(World.BONUS_TYPE_SKIRTING, this.skirtingDuration);
        	}
    		this.skirtingDuration = 0;
    	}
    	
    	if (this.bonusTextAlpha > 0)
    	{
    		this.bonusTextAlpha -= World.BONUS_FADE_SPEED;
    	}
    	
    }
    
    /**
	 * @param bonusType
	 * @param bonusScore
	 */
	private void awardBonus(int bonusType, int bonusScore)
	{
		this.score += bonusScore;
		switch (bonusType)
		{
			case World.BONUS_TYPE_CLOSE_ONE:
				this.bonusText = "Cutting it fine! +" + bonusScore;
				this.closeOneCount++;
				break;
				
			case World.BONUS_TYPE_SKIRTING:
				this.bonusText = "Sparks flying! +" + bonusScore;
				this.totalSparksFlying += bonusScore;	
				if (bonusScore > this.bestSparksFlying)
				{
					this.bestSparksFlying = bonusScore;
				}
				break;
				
			case World.BONUS_TYPE_VERY_CLOSE_ONE:
				this.bonusText = "Sneaky bugger!!! +" + bonusScore;
				this.sneakyBuggerCount++;
				break;
		}
		
		this.bonusTextAlpha = 255;
		
	}

	public void doDyingTick()
    {
    	if (this.ticks > 45)
    	{
    		this.renderDying();
    		game.gameOver();
    		this.setState(World.STATE_GAME_OVER);
    	}
    }
	
    public void render()
    {
    	switch (this.state)
		{
			case World.STATE_STARTING:
				this.renderStarting();
				break;
			
			case World.STATE_PLAYING:
    			this.renderGame();
    			break;
    		
    		case World.STATE_DYING:
    			this.renderDying();
    			break;
		}
    }
    
    public void renderStarting()
    {
    	this.renderGame();
    	
    	int timeRemaining = 3 - (this.ticks / 45);
    	String msg = "Starting in " + timeRemaining; 

		g.fill(0, 0, 0);
		g.text(msg, (g.width >> 1) - (game.font.width(msg) / 2), g.height >> 1);

    }
    
    public void renderGame()
    {
    	g.push();
	    	g.rotateY(BApplet.PI / 8);
	    	g.translate(40, 70, 0);
	
	    	//g.stroke(0, 0, 0, 50);
	    	g.noStroke();
	    	g.fill(200, 200, 200, 100);
	    	// draw ceiling
	    	g.beginShape(BGraphics.QUADS);
	    	g.vertex(World.TUNNEL_START_X, 0, -Bar.HALF_BAR_LENGTH);
	    	g.vertex(World.TUNNEL_END_X, 0, -Bar.HALF_BAR_LENGTH);
	    	g.vertex(World.TUNNEL_END_X, 0, Bar.HALF_BAR_LENGTH);
	    	g.vertex(World.TUNNEL_START_X, 0, Bar.HALF_BAR_LENGTH);
	    	g.endShape();
	    	
	    	// draw floor
	    	g.beginShape(BGraphics.QUADS);
	    	g.vertex(World.TUNNEL_START_X, World.WORLD_HEIGHT, -Bar.HALF_BAR_LENGTH);
	    	g.vertex(World.TUNNEL_END_X, World.WORLD_HEIGHT, -Bar.HALF_BAR_LENGTH);
	    	g.vertex(World.TUNNEL_END_X, World.WORLD_HEIGHT, Bar.HALF_BAR_LENGTH);
	    	g.vertex(World.TUNNEL_START_X, World.WORLD_HEIGHT, Bar.HALF_BAR_LENGTH);
	    	g.endShape();
	    	
	    	g.fill(200, 200, 200, 50);
	    	// draw back panel
	    	g.beginShape(BGraphics.QUADS);
	    	g.vertex(World.TUNNEL_START_X, 0, -Bar.HALF_BAR_LENGTH);
	    	g.vertex(World.TUNNEL_END_X, 0, -Bar.HALF_BAR_LENGTH);
	    	g.vertex(World.TUNNEL_END_X, World.WORLD_HEIGHT, -Bar.HALF_BAR_LENGTH);
	    	g.vertex(World.TUNNEL_START_X, World.WORLD_HEIGHT, -Bar.HALF_BAR_LENGTH);
	    	g.endShape();
	    	
	        for (int i = 0; i < bars.length; i++)
	        {
	            /* DEBUG
	        	g.push();
	            	g.fill(0, 0, 0);
					g.translate(bars[i].x + Bar.HALF_BAR_WIDTH, World.WORLD_HEIGHT - bars[i].h, Bar.HALF_BAR_LENGTH);
	        		g.text("i: " + i, 0, -10);
	        		g.text("h: " + bars[i].h, 0, 10);
	        		g.text("v: " + bars[i].hVelocity, 0, 30);
        		g.pop();
        		*/
	        	bars[i].render(g);
	        }

        	/* DEBUG
	        g.push();
            	g.fill(0, 0, 0);
				g.translate(ship.x2 + 5, World.WORLD_HEIGHT - ship.h, 0);
        		g.text("h: " + (int)ship.h, 0, 10);
    		g.pop();
    		*/
	        
	        ship.render(g);
	    g.pop();
	    g.fill(0, 0, 0, this.bonusTextAlpha);
	    g.text(this.bonusText, g.width - game.font.width(this.bonusText) - 10, g.height - 15);
    }
    
    public void renderScore()
    {
    	g.fill(0, 0, 0);
        g.text("Score: " + this.score, 10, 25);
        g.text("Level: " + this.level, 10, 45);
    }
    
    public void renderDying()
    {
    	g.push();
    		g.translate(-this.ticks * 5, 0, -this.ticks * 6);
    		this.renderGame();
    	g.pop();
    }
    
    public void renderGameOver()
    {
    	g.fill(255, 0, 0);
    	g.text("Game Over!", g.width - game.font.width("Game Over!") - 10, 45);
    }
	
}
