/*
 * Created on 25-Sep-2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author james
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SparkEmitter
{

	Particle[] particles;

    int length;
    private int halfLength;
    Point3D position, offset, minVelocity, maxVelocity;
    boolean running = false;

    SparkEmitter(int particleCount, int length, float floorHeight, float ceilingHeight,
                    Point3D position, Point3D offset, Point3D minVelocity, Point3D maxVelocity)
    {
    
        this.particles = new Particle[particleCount];
    
        this.length = length;
        this.halfLength = length >> 1;
    
        this.position = position.copyOf();
        this.offset = offset.copyOf();
        this.minVelocity = minVelocity.copyOf();
        this.maxVelocity = maxVelocity.copyOf();

        int i = particleCount;
        while (i-- > 0)
        {
            this.particles[i] = new Particle(floorHeight, ceilingHeight);
        }

    }

    void start()
    {
        this.running = true;
    }

    void stop()
    {
        this.running = false;
    }

    void killSparks()
    {
    	int i = particles.length;
        while (i-- > 0)
        {
            this.particles[i].energy = 0;
        }
    }
    
    void doTick(BGraphics g)
    {
        //g.stroke(255, 102, 0, 100);
        int i = particles.length;
        while (i-- > 0)
        {
            particles[i].doTick();
        
            if (particles[i].energy <= 0 && this.running)
            {
                respawnParticle(i);
            }
            
            if (particles[i].energy > 0)
            {
            	//g.stroke(255, 102, 0, 8.5f * particles[i].energy);
            	g.stroke(255, 102 + (particles[i].energy * 10), 0, 150);
            	g.line(particles[i].position.x, particles[i].position.y, particles[i].position.z,
                        particles[i].prevPosition.x, particles[i].prevPosition.y, particles[i].prevPosition.z);
            }
            
        }
    }

    void respawnParticle(int i)
    {
        Point3D p = new Point3D(random(-halfLength, halfLength) + position.x + offset.x, position.y + offset.y, position.z + offset.z);
        Point3D v = new Point3D( random(minVelocity.x, maxVelocity.x),
                                        random(minVelocity.y, maxVelocity.y),
                                        random(minVelocity.z, maxVelocity.z));
        particles[i].init(p, v, (int)random(10, 20));
    }
	
    float random(float min, float max)
    {
    	return (float)(Math.random() * (max - min)) + min;
    }
    
}
