/*
 * Created on Sep 18, 2004
 *
 */

/**
 * @author james
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Ship
{
	public static final int SHIP_LENGTH = 20;
	public static final int SHIP_WIDTH = 10;
	public static final int HALF_SHIP_LENGTH = SHIP_LENGTH >> 1;
	public static final int HALF_SHIP_WIDTH = SHIP_WIDTH >> 1;
	
	private static final float SHIP_THRUST = 0.15f; 
	
	public float h = 100.0f;
	public float prevH = 0.0f;
	public float hVelocity = 0.0f;
	
	public float x, z;

	public float x1;
	public float x2;
	public float z1;
	public float z2;
	
	private SparkManager sparkManager;
	
    /**
     * @param x The world x position of the ship
     * @param z The world z position of the ship 
     */
    Ship(float x, float z)
    {
    	this.x = x;
    	this.z = z;
    	x1 = this.x - Ship.HALF_SHIP_LENGTH;
    	x2 = this.x + Ship.HALF_SHIP_LENGTH;
    	z1 = this.z - Ship.HALF_SHIP_WIDTH;
    	z2 = this.z + Ship.HALF_SHIP_WIDTH;
    	
    	sparkManager = new SparkManager(new Point3D(this.x, (World.WORLD_HEIGHT - this.h), this.z));
    	
    }

    public void init(float h)
    {
    	this.h = h;
    	this.hVelocity = 0;
    	sparkManager.setPosition(new Point3D(this.x, (World.WORLD_HEIGHT - this.h), this.z));
    	sparkManager.init();
    }
    
    public void render(BGraphics g)
    {

        
        float y1 = (World.WORLD_HEIGHT - this.h) - Ship.HALF_SHIP_WIDTH;
        float y2 = (World.WORLD_HEIGHT - this.h) + Ship.HALF_SHIP_WIDTH;
        
        // Draw the ship
    	g.fill(100, 100, 200);
        g.stroke(0, 0, 0);
        
        g.beginShape(BGraphics.QUAD_STRIP);
        g.vertex(x1, y1, z1);
        g.vertex(x2, y1, z1);
        g.vertex(x2, y1, z2);
        g.vertex(x1, y1, z2);
        g.vertex(x1, y2, z2);
        g.vertex(x2, y2, z2);
        g.vertex(x2, y2, z1);
        g.vertex(x1, y2, z1);
        g.vertex(x1, y1, z1);
        g.vertex(x2, y1, z1);
        g.endShape();

        g.beginShape(BGraphics.QUADS);
        g.vertex(x1, y1, z1);
        g.vertex(x1, y2, z1);
        g.vertex(x1, y2, z2);
        g.vertex(x1, y1, z2);
        
        g.vertex(x2, y1, z1);
        g.vertex(x2, y2, z1);
        g.vertex(x2, y2, z2);
        g.vertex(x2, y1, z2);
        g.endShape();
        
        // Draw the bottom shadow
        int shadowAlpha = (int)(((World.WORLD_HEIGHT - this.h) / World.WORLD_HEIGHT) * 200) + 55;
        g.fill(100, 100, 100, shadowAlpha);
        g.noStroke();

        g.beginShape(BGraphics.QUADS);
        g.vertex(x1, World.WORLD_HEIGHT, z1);
        g.vertex(x2, World.WORLD_HEIGHT, z1);
        g.vertex(x2, World.WORLD_HEIGHT, z2);
        g.vertex(x1, World.WORLD_HEIGHT, z2);
        g.endShape();
        
        // Draw the ceiling shadow
        /*
        shadowAlpha = (int)((this.h / World.WORLD_HEIGHT) * 200) + 55;
        g.fill(100, 100, 100, shadowAlpha);
        g.beginShape(BGraphics.QUADS);
        g.vertex(x1, 0, z1);
        g.vertex(x2, 0, z1);
        g.vertex(x2, 0, z2);
        g.vertex(x1, 0, z2);
        g.endShape();
        */
        
        sparkManager.doTick(g);
    }

    public void doTick(boolean mousePressed)
    {
        // If the mouse is down, we are boosting so we apply thrust.
        // Otherwise gravity takes its toll.
        if (mousePressed)
        {
        	this.hVelocity += Ship.SHIP_THRUST;
        }
        else
        {
        	this.hVelocity += World.G;
        }
        
        // Apply force
        this.h += this.hVelocity;
        
        // Collision test
        if (this.h <= Ship.HALF_SHIP_WIDTH)
        {
            this.h = Ship.HALF_SHIP_WIDTH;
            this.hVelocity = 0;
        }
        if (this.h >= World.WORLD_HEIGHT)
        {
        	this.h = World.WORLD_HEIGHT - Ship.HALF_SHIP_WIDTH;
        	this.hVelocity = 0;
        }
        
        // Update spark manager position
        sparkManager.setPosition(new Point3D(this.x, (World.WORLD_HEIGHT - this.h), this.z));
        
    }
}
