import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;

/*
 * Created on 22-Sep-2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author james
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class HighScoreTable
{

	private Game game;
	private BGraphics g;
	
	public String name = "";
	public int score = 0;
	private String scoreData = "";
	
	public int levelReached = 0;
	public int barsPassed = 0;
	public int closeOneCount = 0;
	public int sneakyBuggerCount = 0;
	public int bestSparksFlying = 0;
	public int totalSparksFlying = 0;
	
	private static final int MAX_NAME_LENGTH = 6;
	
	private static final int BOX_WIDTH = 26;
	private static final int BOX_SPACING = 2;
	
	private static final int ROW_COUNT = 4;
	private static final int COL_COUNT = 10;

	public static final int STATE_SCORE_BREAKDOWN = 0;
	public static final int STATE_ENTER_NAME = 1;
	public static final int STATE_UPLOADING = 2;
	public static final int STATE_SHOW_TABLE = 4;
	
	public int state = STATE_ENTER_NAME;

	private int offsetX;
	private int offsetY;
	
	private static final String TABLE_URL = "http://localhost";
	
	private int selected = -1;
	private char[][] characters =	{
										{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'},
										{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'},
										{'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T'},
										{'U', 'V', 'W', 'X', 'Y', 'Z', ' ', ' ', '<', '>'}
									};
	
	private String[] names = {"", "", "", "", "", "", "", "", "", ""};
	private String[] scores = {"", "", "", "", "", "", "", "", "", ""};
	
	public HighScoreTable(Game game, BGraphics g)
	{
		this.game = game;
		this.g = g;
		this.offsetX = (g.width - (HighScoreTable.BOX_WIDTH * HighScoreTable.COL_COUNT)) / 2;
		this.offsetY = (g.height - (HighScoreTable.BOX_WIDTH * HighScoreTable.ROW_COUNT)) / 2;
		this.uploadScore();
	}
	
	public void init(int score, int levelReached, int barsPassed, int closeOneCount,
						int sneakyBuggerCount, int bestSparksFlying, int totalSparksFlying)
	{
		this.selected = -1;
		this.state = STATE_SCORE_BREAKDOWN;
		this.score = score;
		this.levelReached = levelReached;
		this.barsPassed = barsPassed;
		this.closeOneCount = closeOneCount;
		this.sneakyBuggerCount = sneakyBuggerCount;
		this.bestSparksFlying = bestSparksFlying;
		this.totalSparksFlying = totalSparksFlying;
	}
	
	private void uploadScore()
	{
		/*
		*	Aye right! Like I'm actually going to leave this in here.
		*	Away wi ye ya cheeky wee bam!
		*/
		this.state = HighScoreTable.STATE_SHOW_TABLE;
	}
	
	public void render()
	{
		switch (this.state)
		{
			case HighScoreTable.STATE_SCORE_BREAKDOWN:
				this.renderScoreBreakdown();
				break;
				
			case HighScoreTable.STATE_ENTER_NAME:
				this.renderNameEntry();
				break;
				
			case HighScoreTable.STATE_UPLOADING:
				this.renderNameEntry();
				break;
				
			case HighScoreTable.STATE_SHOW_TABLE:
				this.renderTable();
				break;
		}
	}
	
	private void renderScoreBreakdown()
	{
		float maxTextWidth = game.font.width("Total sparks flying:");
		float maxScoreWidth = game.font.width("000000");
		
		int tableWidth = (int)(maxTextWidth + maxScoreWidth) + 30;
		int textX = (g.width - tableWidth) / 2;
		
		g.stroke(0, 0, 0);
		g.fill(255, 255, 255);
		g.rectMode(BGraphics.CORNER);
		g.rect(textX - 10, 75, tableWidth + 20, 175);
		
		int topY = 80;
		
		g.fill(0, 0, 0);
		
		g.text("Level reached:", textX, topY + 20);
		g.text(this.levelReached, tableWidth + textX - game.font.width(this.levelReached + ""), topY + 20);
		
		g.text("Bars passed:", textX, topY + 40);
		g.text(this.barsPassed, tableWidth + textX - game.font.width(this.barsPassed + ""), topY + 40);
		
		g.text("Best sparks flying:", textX, topY + 60);
		g.text(this.bestSparksFlying, tableWidth + textX - game.font.width(this.bestSparksFlying + ""), topY + 60);
		
		g.text("Total sparks flying:", textX, topY + 80);
		g.text(this.totalSparksFlying, tableWidth + textX - game.font.width(this.totalSparksFlying + ""), topY + 80);
		
		g.text("Cutting it fine:", textX, topY + 100);
		g.text(this.closeOneCount, tableWidth + textX - game.font.width(this.closeOneCount + ""), topY + 100);
		
		g.text("Sneaky buggers:", textX, topY + 120);
		g.text(this.sneakyBuggerCount, tableWidth + textX - game.font.width(this.sneakyBuggerCount + ""), topY + 120);
		
		g.text("Score:", textX, topY + 160);
		g.text(this.score, tableWidth + textX - game.font.width(this.score + ""), topY + 160);
		
	}
	
	private void renderNameEntry()
	{
		g.textFont(game.font, Game.FONT_SIZE);
		int i = 0;
		g.push();
			g.translate(offsetX, offsetY);
			for (int row = 0; row < characters.length; row++)
			{
				for (int col = 0; col < characters[row].length; col++)
				{
					boolean highlight = selected == i;
					renderChar(characters[row][col], row, col, highlight);
					i++;
				}
			}
			int x = (int)(((HighScoreTable.COL_COUNT * HighScoreTable.BOX_WIDTH) / 2) - (game.font.width(name) / 2));
			int y = (int)((HighScoreTable.ROW_COUNT * HighScoreTable.BOX_WIDTH) + (Game.FONT_SIZE));
			g.fill(0, 0, 0);
			g.text(name, x, y);
			x = (int)(((HighScoreTable.COL_COUNT * HighScoreTable.BOX_WIDTH) / 2) - (game.font.width("Enter Your Name:") / 2));
			y = -10;
			g.text("Enter Your Name:", x, y);
		g.pop();
	}
	
	private void renderChar(char character, int row, int col, boolean highlighted)
	{
		if (character == ' ')
		{
			return;
		}
		int x = (col * BOX_WIDTH);
		int y = (row * BOX_WIDTH);
		float charWidth = game.font.width(character);
		
		if (highlighted)
		{
			g.noStroke();
			if (character == '<')
			{
				g.fill(255, 100, 100);
			}
			else if (character == '>')
			{
				g.fill(100, 200, 100);
			}
			else
			{
				g.fill(100, 100, 200);
			}
			g.rect(x + BOX_SPACING, y + BOX_SPACING, BOX_WIDTH - BOX_SPACING + 1, BOX_WIDTH - BOX_SPACING + 1);
		}
		else
		{
			g.stroke(0, 0, 0);			
			g.fill(255, 255, 255);
			g.rect(x + BOX_SPACING, y + BOX_SPACING, BOX_WIDTH - BOX_SPACING, BOX_WIDTH - BOX_SPACING);
		}
		

		if (highlighted)
		{
			g.fill(255, 255, 255);
		}
		else
		{
			g.fill(0, 0, 0);
		}
		
		x += (HighScoreTable.BOX_WIDTH / 2) - (charWidth / 2) + HighScoreTable.BOX_SPACING;
		y += (HighScoreTable.BOX_WIDTH / 2) + 8;
		//g.push();
			// draw the characters 1 unit closer to the screen than the boxes
			// prevents any confusion as to which should be occluded 
			//g.translate(0, 0, 1);
			g.text(character, x, y);
		//g.pop();
		
	}
	
	private void renderTable()
	{
		float maxNameWidth = game.font.width("10: WWWWWW");
		float numberWidth = game.font.width("10: ");
		float maxScoreWidth = 0;
		for (int i = 0; i < scores.length; i++)
		{
			float scoreWidth = game.font.width(String.valueOf(scores[i]));
			if (scoreWidth > maxScoreWidth)
			{
				maxScoreWidth = scoreWidth;
			}
		}
		int tableWidth = (int)(maxNameWidth + maxScoreWidth) + 30;
		int nameX = (g.width - tableWidth) / 2;
		int topY = 80;
		
		g.stroke(0, 0, 0);
		g.fill(255, 255, 255);
		g.rectMode(BGraphics.CORNER);
		g.rect(nameX - 10, topY - 25, tableWidth + 20, (names.length * 20) + 20);
		
		g.fill(0, 0, 0);
		for (int i = 0; i < names.length; i++)
		{
			int y = (i * 20) + topY;
			String entryNumber = (i + 1) + ":";
			g.text(entryNumber, nameX, y);
			g.text(names[i], nameX + numberWidth, y);
			g.text(scores[i], tableWidth + nameX - game.font.width(scores[i]), y);
		}

	}
	
	public void mouseMoved()
	{
		switch (this.state)
		{
			case HighScoreTable.STATE_ENTER_NAME:
				float fCol = (game.mouseX - offsetX) / (float)HighScoreTable.BOX_WIDTH;
				float fRow = (game.mouseY - offsetY) / (float)HighScoreTable.BOX_WIDTH;
				int col = fCol < 0 ? -1 : (int)fCol;
				int row = fRow < 0 ? -1 : (int)fRow;

				if (row < HighScoreTable.ROW_COUNT && col < HighScoreTable.COL_COUNT && row > -1 && col > -1)
				{
					if (characters[row][col] == ' ')
					{
						selected = -1;
						game.cursor(BGraphics.ARROW);
					}
					else
					{
						selected = (row * HighScoreTable.COL_COUNT) + col;
						game.cursor(BGraphics.HAND);
					}
				}
				else
				{
					selected = -1;
					game.cursor(BGraphics.ARROW);
				}
				//System.out.println("Mouse == (" + mouseX + ", " + mouseY + ") : Matrix == (" + row + ", " + col + ") : Selected == " + selected);
				break;
				
			case STATE_SHOW_TABLE:
			
				break;
				
		}
		
	}
	
	public void mousePressed()
	{
		switch (this.state)
		{
			case HighScoreTable.STATE_SCORE_BREAKDOWN:
				this.state = HighScoreTable.STATE_ENTER_NAME;
				break;
			
			case HighScoreTable.STATE_ENTER_NAME:
				if (selected > -1)
				{
					char character = characters[selected / HighScoreTable.COL_COUNT][selected % HighScoreTable.COL_COUNT];
					if (character == '<')
					{
						if (name.length() > 0)
						{
							name = name.substring(0, name.length() - 1);
						}
					}
					else if (character == '>')
					{
						this.state = HighScoreTable.STATE_UPLOADING;
						uploadScore();
					}
					else if (name.length() < HighScoreTable.MAX_NAME_LENGTH)
					{
						name += character;
					}
				}
				break;
				
			case HighScoreTable.STATE_SHOW_TABLE:
				game.hideTable();
				break;
		}
	}
	
}
