/*
 * Created on Sep 13, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author james
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Game extends BApplet
{

	public static final String GAME_NAME = "tunnel";
	
	World world;
	HighScoreTable highScoreTable;
	BFont font;
	
	public static final int FONT_SIZE = 24;
	
	private static final int STATE_MENU = 1;
	private static final int STATE_PLAYING = 2;
	private static final int STATE_HIGH_SCORE = 4;
	private int state = STATE_MENU;
	
	boolean isSmooth = false;
	boolean isPaused = false;
	
	public BImage gameImage;
	
	void setup()
	{
	    font = loadFont("Arial_Black.vlw");
	    textFont(font, Game.FONT_SIZE);
	    framerate(45);
	    size(400, 300);
	    if (isSmooth)
	    {
	    	smooth();
	    }
	    else
	    {
	    	noSmooth();
	    }
	    highScoreTable = new HighScoreTable(this, this.g);
	    world = new World(this);
	    background(255, 255, 255);
	    gameImage = copy();
	}

	void loop()
	{

		background(255, 255, 255);
	    
	    switch (this.state)
		{
	    	case Game.STATE_PLAYING:
	    		if (isPaused)
	    		{
	    			text("Paused", (width >> 1) - 40, height >> 1);
	    			return;
	    		}
	    		world.doTick();
	    		world.render();
	    		world.renderScore();
	    		break;
	    		
	    	case Game.STATE_MENU:
	    	case Game.STATE_HIGH_SCORE:
	    		push();
	    			translate(0, 0, -2);
	    			image(gameImage, 0, 0, width, height);
	    		pop();
	    		world.renderScore();

	    		highScoreTable.render();
	    		if (highScoreTable.state == HighScoreTable.STATE_SHOW_TABLE)
	    		{
	    			fill(0, 0, 0);
	    			g.text("Click to play!", width - font.width("Click to play!") - 10, 25);
	    		}
	    		else if (highScoreTable.state == HighScoreTable.STATE_SCORE_BREAKDOWN)
	    		{
	    			fill(0, 0, 0);
	    			g.text("Click to continue!", width - font.width("Click to continue!") - 10, 25);
	    		}
	    		else
	    		{
	    			world.renderGameOver();
	    		}
	    		break;
		}
	    
	}
	
	public void gameOver()
	{
		world.renderDying();
		gameImage = copy();

		this.state = Game.STATE_HIGH_SCORE;
		this.highScoreTable.init(world.score, world.level, world.barsPassed, world.closeOneCount,
									world.sneakyBuggerCount, world.bestSparksFlying, world.totalSparksFlying);
	}
	
	public void hideTable()
	{
		startGame();
	}
	
	public void startGame()
	{
		this.state = Game.STATE_PLAYING;
		world.init();
	}
	
	void mouseMoved()
	{
		if (world.state == World.STATE_GAME_OVER)
		{
			highScoreTable.mouseMoved();
		}
	}
	
	void mousePressed()
	{
		switch (this.state)
		{
			case Game.STATE_HIGH_SCORE:
				highScoreTable.mousePressed();
				break;
				
			case Game.STATE_MENU:
				this.startGame();
				break;
		}
	}
	
	void keyPressed()
	{
		if (key == 's' || key == 'S')
		{
			if (isSmooth)
			{
				noSmooth();
			}
			else
			{
				smooth();
			}
			isSmooth = !isSmooth;
			return;
		}

		switch(this.state)
		{
			case Game.STATE_PLAYING:
				if (key == 'p' || key == 'P')
				{
					isPaused = !isPaused;
				}
				break;
				
			case Game.STATE_HIGH_SCORE:
				switch (highScoreTable.state)
				{
					case HighScoreTable.STATE_SHOW_TABLE:
						startGame();
						break;
				}
				break;
				
			case Game.STATE_MENU:
				startGame();
				break;
		}
			
	}
	
	void blur(int tt)
	{
	    for (int ttt = 0; ttt <=  tt; ttt++)
	    {
	        int R, G, B, left, right, top, bottom;
	        int c, cl, cr, ct, cb;
	        int w1 = width - 1;
	        int h1 = height - 1;
	        int index = 0;
	        for (int y = 0; y < height; y++)
	        {
	            top = (y > 0) ?  -width : h1 * width;
	            bottom = (y == h1) ?  -h1 * width : width;
	            for (int x = 0; x < width; x++)
	            {
	                // Wraparound offsets
	                left = (x > 0) ?  -1 : w1;
	                right = (x < w1) ? 1 :  -w1;
	                
	                c = pixels[index];
	                cl = pixels[left + index];
	                cr = pixels[right + index];
	                ct = pixels[top + index];
	                cb = pixels[bottom + index];
	                
	                // Calculate the sum of all neighbors
	                R = ((cl >> 16 & 255) + (cr >> 16 & 255) + (c >> 16 & 255) + (ct >> 16 & 255) + (cb >> 16 & 255)) / 5;
	                G = ((cl >> 8 & 255) + (cr >> 8 & 255) + (c >> 8 & 255) + (ct >> 8 & 255) + (cb >> 8 & 255)) / 5;
	                B = ((cl & 255) + (cr & 255) + (c & 255) + (ct & 255) + (cb & 255)) / 5;
	                pixels[index++] = (R << 16) + (G << 8) + B;
	            }
	        }
	    }
	}
	
}
