/*
 * Created on Sep 18, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author james
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Bar
{
	public static final int BAR_WIDTH = 10;
	public static final int BAR_LENGTH = 100;
	public static final int HALF_BAR_LENGTH = BAR_LENGTH >> 1;
	public static final int HALF_BAR_WIDTH = BAR_WIDTH >> 1;
	
	public float h, x, z;
    public float prevH, prevX, prevZ;
    public float hVelocity = 0.0f, xVelocity = -2.0f;
    
    private static final int BONUS_START_X = World.BAR_DISTANCE << 1;
	private static final int BONUS_TARGET_ALPHA = 50;
    private static final float BONUS_ALPHA_SPEED = 0.5f;
    
    private float bonusAlpha = 0;
    
    Bar(float h, float x, float z)
    {
        this.prevH = this.h = h;
        this.prevX = this.x = x;
        this.prevZ = this.z = z;
    }
    
    public void render(BGraphics g)
    {
        
    	float x1 = this.x - Bar.HALF_BAR_WIDTH;
    	float x2 = this.x + Bar.HALF_BAR_WIDTH;
    	float y1 = (World.WORLD_HEIGHT - this.h) - Bar.HALF_BAR_WIDTH; 
    	float y2 = (World.WORLD_HEIGHT - this.h) + Bar.HALF_BAR_WIDTH;
    	float z1 = this.z - Bar.HALF_BAR_LENGTH;
    	float z2 = this.z + Bar.HALF_BAR_LENGTH;
    	
    	// Draw bar
    	g.fill(255, 255, 255);
        g.stroke(0, 0, 0);
        g.beginShape(BGraphics.QUAD_STRIP);
        g.vertex(x1, y1, z1);
        g.vertex(x2, y1, z1);
        g.vertex(x2, y1, z2);
        g.vertex(x1, y1, z2);
        g.vertex(x1, y2, z2);
        g.vertex(x2, y2, z2);
        g.vertex(x2, y2, z1);
        g.vertex(x1, y2, z1);
        g.vertex(x1, y1, z1);
        g.vertex(x2, y1, z1);
        g.endShape();

        g.beginShape(BGraphics.QUADS);
        g.vertex(x1, y1, z1);
        g.vertex(x1, y2, z1);
        g.vertex(x1, y2, z2);
        g.vertex(x1, y1, z2);
        
        g.vertex(x2, y1, z1);
        g.vertex(x2, y2, z1);
        g.vertex(x2, y2, z2);
        g.vertex(x2, y1, z2);
        g.endShape();
        
        // Draw the shadows
        int shadowAlpha = (int)(((World.WORLD_HEIGHT - this.h) / World.WORLD_HEIGHT) * 200) + 55;
        g.fill(100, 100, 100, shadowAlpha);
        g.noStroke();
        // Draw the bottom shadow
        g.beginShape(BGraphics.QUADS);
        g.vertex(x1, World.WORLD_HEIGHT, z1);
        g.vertex(x2, World.WORLD_HEIGHT, z1);
        g.vertex(x2, World.WORLD_HEIGHT, z2);
        g.vertex(x1, World.WORLD_HEIGHT, z2);
        g.endShape();
        
        if (this.x < Bar.BONUS_START_X)
        {
        	g.noStroke();
        	
        	// Render top bonus
        	if (h > World.WORLD_HEIGHT - (World.WORLD_HEIGHT >> 2))
    		{
    			g.fill(255, 0, 0, bonusAlpha);
    		}
    		else if (h > World.WORLD_HEIGHT >> 1)
    		{
    			g.fill(255, 255, 0, bonusAlpha);
    		}
    		else
    		{
    			g.fill(0, 255, 0, bonusAlpha);
    		}
        	y1 = 0;
        	y2 = World.WORLD_HEIGHT - h - Bar.HALF_BAR_WIDTH;
        	g.beginShape(BGraphics.QUADS);
        	g.vertex(this.x, y1, z1);
        	g.vertex(this.x, y2, z1);
        	g.vertex(this.x, y2, z2);
        	g.vertex(this.x, y1, z2);
        	g.endShape();
        	
        	// Render bottom bonus
        	if (h < World.WORLD_HEIGHT >> 2)
    		{
    			g.fill(255, 0, 0, bonusAlpha);
    		}
    		else if (h < World.WORLD_HEIGHT >> 1)
    		{
    			g.fill(255, 255, 0, bonusAlpha);
    		}
    		else
    		{
    			g.fill(0, 255, 0, bonusAlpha);
    		}
        	y1 = World.WORLD_HEIGHT - h + Bar.HALF_BAR_WIDTH;
        	y2 = World.WORLD_HEIGHT;
        	g.beginShape(BGraphics.QUADS);
        	g.vertex(this.x, y1, z1);
        	g.vertex(this.x, y2, z1);
        	g.vertex(this.x, y2, z2);
        	g.vertex(this.x, y1, z2);
        	g.endShape();
        }
        
    }
    
    public void doTick()
    {
        this.prevX = this.x;
        this.prevH = this.h;
    	this.x += this.xVelocity;
        this.h += this.hVelocity;
        if (this.h <= Bar.HALF_BAR_WIDTH)
        {
        	this.h = Bar.HALF_BAR_WIDTH;
        	this.hVelocity *= -1;
        }
        
        if (this.h > World.WORLD_HEIGHT - Bar.HALF_BAR_WIDTH)
        {
        	this.h = World.WORLD_HEIGHT - Bar.HALF_BAR_WIDTH;
        	this.hVelocity *= -1;
        }
        
        if (this.x < Bar.BONUS_START_X && this.bonusAlpha <= Bar.BONUS_TARGET_ALPHA)
        {
        	this.bonusAlpha++;
        }
    }
    
    public void reset(float h, float x, float hVelocity)
    {
    	this.h = h;
    	this.x = x;
    	this.hVelocity = hVelocity;
    	this.bonusAlpha = 0;
    }
}
